/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.IBurpExtender;
import burp.IBurpExtenderCallbacks;
import burp.IHttpListener;
import burp.IHttpRequestResponse;
import burp.IHttpRequestResponseWithMarkers;
import burp.IHttpService;
import burp.IRequestInfo;
import burp.IScanIssue;
import burp.IScannerCheck;
import burp.IScannerInsertionPoint;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BurpExtender
implements IBurpExtender,
IHttpListener {
    private IBurpExtenderCallbacks callbacks = null;
    private final Map<Pattern, HighlightColor> bannerMap = new HashMap<Pattern, HighlightColor>();
    private boolean burpProfessional = false;

    @Override
    public void registerExtenderCallbacks(IBurpExtenderCallbacks callbacks) {
        this.callbacks = callbacks;
        String[] version = callbacks.getBurpVersion();
        this.burpProfessional = 0 <= version[0].indexOf("Professional");
        this.bannerMap.put(Pattern.compile("(Apache/[0-9.]+)"), HighlightColor.GREEN);
        this.bannerMap.put(Pattern.compile("(PHP/[0-9.]+)"), HighlightColor.GREEN);
        if (this.burpProfessional) {
            callbacks.registerScannerCheck(this.professionalPassiveScanCheck());
        } else {
            callbacks.registerHttpListener(this);
        }
    }

    public IScannerCheck professionalPassiveScanCheck() {
        return new IScannerCheck(){

            @Override
            public List<IScanIssue> doPassiveScan(IHttpRequestResponse baseRequestResponse) {
                String message = BurpExtender.getByteToStr(baseRequestResponse.getResponse());
                ArrayList<int[]> responseMarkers = new ArrayList<int[]>();
                for (Pattern ptn : BurpExtender.this.bannerMap.keySet()) {
                    Matcher m = ptn.matcher(message);
                    while (m.find()) {
                        responseMarkers.add(new int[]{m.start(), m.end()});
                    }
                }
                if (responseMarkers.size() > 0) {
                    ArrayList<IScanIssue> issues = new ArrayList<IScanIssue>();
                    IHttpRequestResponseWithMarkers messageInfoMark = BurpExtender.this.callbacks.applyMarkers(baseRequestResponse, null, responseMarkers);
                    issues.add(BurpExtender.this.makeBannerIssue(messageInfoMark));
                    return issues;
                }
                return null;
            }

            @Override
            public List<IScanIssue> doActiveScan(IHttpRequestResponse baseRequestResponse, IScannerInsertionPoint insertionPoint) {
                return null;
            }

            @Override
            public int consolidateDuplicateIssues(IScanIssue existingIssue, IScanIssue newIssue) {
                if (existingIssue.getIssueName().equals(newIssue.getIssueName())) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public IScanIssue makeBannerIssue(final IHttpRequestResponse messageInfo) {
        return new IScanIssue(){

            @Override
            public URL getUrl() {
                IRequestInfo reqInfo = BurpExtender.this.callbacks.getHelpers().analyzeRequest(messageInfo.getHttpService(), messageInfo.getRequest());
                return reqInfo.getUrl();
            }

            @Override
            public String getIssueName() {
                return "Server Banner Disclosure";
            }

            @Override
            public int getIssueType() {
                return 0x8000000;
            }

            @Override
            public String getSeverity() {
                return "Information";
            }

            @Override
            public String getConfidence() {
                return "Certain";
            }

            @Override
            public String getIssueBackground() {
                return "omission";
            }

            @Override
            public String getRemediationBackground() {
                return "omission";
            }

            @Override
            public String getIssueDetail() {
                return "omission";
            }

            @Override
            public String getRemediationDetail() {
                return "omission";
            }

            @Override
            public IHttpRequestResponse[] getHttpMessages() {
                return new IHttpRequestResponse[]{messageInfo};
            }

            @Override
            public IHttpService getHttpService() {
                return messageInfo.getHttpService();
            }
        };
    }

    @Override
    public void processHttpMessage(int toolFlag, boolean messageIsRequest, IHttpRequestResponse messageInfo) {
        if (toolFlag == 4 && !messageIsRequest) {
            this.freePassiveScan(messageInfo);
        }
    }

    public void freePassiveScan(IHttpRequestResponse messageInfo) {
        String message = BurpExtender.getByteToStr(messageInfo.getResponse());
        for (Pattern ptn : this.bannerMap.keySet()) {
            Matcher m = ptn.matcher(message);
            if (!m.find()) continue;
            String bunner = m.group(1);
            HighlightColor color = this.bannerMap.get(ptn);
            String comment = messageInfo.getComment() == null ? "" : messageInfo.getComment() + " ";
            messageInfo.setComment(comment + bunner);
            messageInfo.setHighlight(color.toString());
        }
    }

    public static byte[] getStrToByte(String str) {
        return str.getBytes(StandardCharsets.ISO_8859_1);
    }

    public static String getByteToStr(byte[] bytes) {
        return new String(bytes, 0, bytes.length, StandardCharsets.ISO_8859_1);
    }

    public static enum HighlightColor {
        WHITE,
        RED,
        ORANGE,
        YELLOW,
        GREEN,
        CYAN,
        BLUE,
        PINK,
        MAGENTA,
        GRAY;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

