/*
 * Decompiled with CFR 0.152.
 */
package extenderlauncher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Config {
    public static final String CONFIG_XML = "config.xml";
    private final List<LaunchItem> launcherList = new ArrayList<LaunchItem>();

    public static String getUserHome() {
        return System.getProperties().getProperty("user.home");
    }

    public void loadFromXML() {
        Properties prop = new Properties();
        try {
            FileInputStream is = new FileInputStream(new File(Config.getUserHome(), CONFIG_XML));
            prop.loadFromXML(is);
            this.launcherList.clear();
            int index = 0;
            while (true) {
                String caption = prop.getProperty(String.format("launch[%d].caption", index), null);
                String target = prop.getProperty(String.format("launch[%d].target", index), null);
                if (caption != null && target != null) {
                    LaunchItem launchItem = new LaunchItem(){
                        private String caption;
                        private String target;

                        @Override
                        public void setCaption(String caption) {
                            this.caption = caption;
                        }

                        @Override
                        public String getCaption() {
                            return this.caption;
                        }

                        @Override
                        public void setTarget(String target) {
                            this.target = target;
                        }

                        @Override
                        public String getTerget() {
                            return this.target;
                        }
                    };
                    launchItem.setCaption(caption);
                    launchItem.setTarget(target);
                    this.launcherList.add(launchItem);
                    ++index;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<LaunchItem> getLauncherList() {
        return this.launcherList;
    }

    public static interface LaunchItem {
        public void setCaption(String var1);

        public void setTarget(String var1);

        public String getCaption();

        public String getTerget();
    }
}

